#include <ws_SPI.h>
#include <nRF24L01reg.h>
#include <nRF24L01.h>
/*********************************************************************
**  Constant Declaration
*********************************************************************/
#define Uint8  u8
#define Uint16  u16
#define Uint8  u8

#define    cCommand_RxFifoRead      0x61
#define    cCommand_TxFifoWrite     0xa0
#define    cCommand_TxFifoFlush     0xe1
#define    cCommand_RxFifoFlush     0xe2

/******   STATUSĴbitλ      *******/
#define MAX_TX  	0x10  	  //ﵽʹж
#define TX_OK   	0x20  	  //TXж
#define RX_OK   	0x40  	  //յж
/**/

/*********     24L01ͽݿȶ	  ***********/
#define TX_ADR_WIDTH    5     //5ֽڵַ
#define RX_ADR_WIDTH    5     //5ֽڵַ
#define TX_PLOAD_WIDTH  32    //32ֽЧݿ
#define RX_PLOAD_WIDTH  32    //32ֽЧݿ

Uint8 TX_ADDRESS[TX_ADR_WIDTH]={0xFF,0xFF,0xFF,0xFF,0xFF}; //͵ַ
Uint8 RX_ADDRESS[RX_ADR_WIDTH]={0xFF,0xFF,0xFF,0xFF,0xFF}; //յַ



/*********************************************************************
** Nrf24l01_InterFace
*********************************************************************/
void Nrf24l01_InterFace(void)
{
    //init io pin		
		sbi(PA_DDR,3);//CSN OUTPUT
		sbi(PA_CR1,3);
		cbi(PA_CR2,3);
		
		sbi(PC_DDR,5);//SCK OUTPUT
		sbi(PC_CR1,5);
		cbi(PC_CR2,5);
		
		sbi(PC_DDR,6);//MOSI OUTPUT
		sbi(PC_CR1,6);
		cbi(PC_CR2,6);
		
		cbi(PC_DDR,7);//MISO INPUT
		sbi(PC_CR1,7);
		cbi(PC_CR2,7);
		
		cbi(PD_DDR,2);//GIO1 WTR INPUT IRQ
		sbi(PD_CR1,2);
		cbi(PD_CR2,2);
					
		sbi(PC_DDR,4);//CE OUTPUT
	  sbi(PC_CR1,4);
	  cbi(PC_CR2,4);
		
		cbi(PD_DDR,3);//key INPUT
	  sbi(PD_CR1,3);
	  cbi(PD_CR2,3);

    cbi(PD_DDR,4);//key INPUT
	  sbi(PD_CR1,4);
	  cbi(PD_CR2,4); 
	
		sbi(PD_DDR,6);//RED_LED OUTPUT
		sbi(PD_CR1,6);
		cbi(PD_CR2,6);

		sbi(PD_DDR,5);//GRE_LED OUTPUT
	  sbi(PD_CR1,5);
	  cbi(PD_CR2,5);
		
		sbi(PC_DDR,3);//HEAT OUTPUT
	  sbi(PC_CR1,3);
	  cbi(PC_CR2,3);
		
    sbi(PA_ODR,3);
    cbi(PC_ODR,5);//SCK = 0;
    sbi(PC_ODR,6);//SDIO = 1;
		
		cbi(PD_DDR,2);//SET INPUT
	  sbi(PD_CR1,2);
	  cbi(PD_CR2,2);
		SPI_Init();
}


Uint8 SPI_RW(Uint8 byte)
{
	Uint8 bit_ctr;
	for(bit_ctr=0;bit_ctr<8;bit_ctr++)  // 8λ
	{
		if(byte&0x80)sbi(PC_DDR,6);
			else cbi(PC_DDR,6);// MSB TO MOSI
		byte=(byte<<1);					// shift next bit to MSB
		sbi(PC_ODR,5);//SCK = 1;
		byte|=gbi(PC_CR1,7);	        		// capture current MISO bit
		cbi(PC_ODR,5);//SCK = 0;
	}
	return byte;
}

/*********************************************/
/* ܣ24L01ļĴдֵһֽڣ */
/* ڲreg   ҪдļĴַ          */
/*           value Ĵдֵ            */
/* ڲstatus ״ֵ̬                   */
/*********************************************/
Uint8 NRF24L01_Write_Reg(Uint8 reg,Uint8 value)
{
	Uint8 status;
	cbi(PA_DDR,3);                  //CSN=0;  
	status = SPI_RW(reg);		//ͼĴַ, ȡ״ֵ̬	
	SPI_RW(value);
	sbi(PA_DDR,3);                  //CSN=1;

	return status;
}
/*************************************************/
/* ܣ24L01ļĴֵ һֽڣ      */
/* ڲreg  ҪļĴַ               */
/* ڲvalue Ĵֵ                */
/*************************************************/
Uint8 NRF24L01_Read_Reg(Uint8 reg)
{
 	Uint8 value;

	cbi(PA_DDR,3);              //CSN=0;   
	SPI_RW(reg);			//ͼĴֵ(λ),ȡ״ֵ̬
	value = SPI_RW(NOP);
	sbi(PA_DDR,3);             	//CSN=1;

	return value;
}
/*********************************************/
/* ܣ24L01ļĴֵֽڣ   */
/* ڲreg   Ĵַ                */
/*           *pBuf ĴֵĴ    */
/*           len   ֽڳ              */
/* ڲstatus ״ֵ̬                   */
/*********************************************/
Uint8 NRF24L01_Read_Buf(Uint8 reg,Uint8 *pBuf,Uint8 len)
{
	Uint8 status,u8_ctr;
	cbi(PA_DDR,3);                   	//CSN=0       
  status=SPI_RW(reg);		//ͼĴַ, ȡ״ֵ̬	
 	for(u8_ctr=0;u8_ctr<len;u8_ctr++)
	pBuf[u8_ctr]=SPI_RW(0XFF);		//
	sbi(PA_DDR,3);                 		//CSN=1
	return status;        			//ض״ֵ̬
}
/**********************************************/
/* ܣ24L01ļĴдֵֽڣ  */
/* ڲreg  ҪдļĴַ            */
/*           *pBuf ֵĴ               */
/*           len   ֽڳ               */
/**********************************************/
Uint8 NRF24L01_Write_Buf(Uint8 reg, Uint8 *pBuf, Uint8 len)
{
	Uint8 status,u8_ctr;
	cbi(PA_DDR,3);
  status = SPI_RW(reg);		//ͼĴַ, ȡ״ֵ̬	
	for(u8_ctr=0; u8_ctr<len; u8_ctr++)
	SPI_RW(*pBuf++);				//д
	sbi(PA_DDR,3);
	return status;          		//ض״ֵ̬
}							  					   

/*********************************************/
/* ܣ24L01                   */
/* ڲrxbuf               */
/* ֵ 0   ɹյ                 */
/*          1   ûյ                 */
/*********************************************/
Uint8 NRF24L01_RxPacket(Uint8 *rxbuf)
{
	Uint8 state;Uint8 temp;
	 
	state=NRF24L01_Read_Reg(STATUS);  			//ȡ״̬Ĵֵ    	 
	NRF24L01_Write_Reg(WRITE_REG+STATUS,state); //TX_DSMAX_RTжϱ־
	if(state&RX_OK)								//յ
	{
		cbi(PC_DDR,4);
		NRF24L01_Read_Buf(RD_RX_PLOAD,rxbuf,RX_PLOAD_WIDTH);//ȡ
		NRF24L01_Write_Reg(FLUSH_RX,0xff);					//RX FIFOĴ
		sbi(PC_DDR,4);
		delay_us(150);
		return 0; 
	}	   
	return 1;//ûյκ
}
/**********************************************/
/* ܣ24L01Ϊģʽ              */
/* ڲtxbuf                */
/* ֵ 0x10    ﵽطʧ*/
/*          0x20    ɹ              */
/*          0xff    ʧ                  */
/**********************************************/
Uint8 NRF24L01_TxPacket(Uint8 *txbuf)
{
	Uint8 state;
  cbi(PC_DDR,4); 	//CEͣʹ24L01
  NRF24L01_Write_Buf(WR_TX_PLOAD,txbuf,TX_PLOAD_WIDTH);	//дݵTX BUF  32ֽ
 	sbi(PC_DDR,4);												//CEøߣʹܷ	   
	while(gbi(PD_DDR,2)==1);										//ȴ
	state=NRF24L01_Read_Reg(STATUS);  						//ȡ״̬Ĵֵ	   
	NRF24L01_Write_Reg(WRITE_REG+STATUS,state); 			//TX_DSMAX_RTжϱ־
	if(state&MAX_TX)										//ﵽط
	{
		NRF24L01_Write_Reg(FLUSH_TX,0xff);					//TX FIFOĴ 
		return MAX_TX; 
	}
	if(state&TX_OK)											//
	{
		return TX_OK;
	}
	return 0xff;											//ʧ
}

/********************************************/
/* ܣ24L01Ƿ              */
/* ֵ  0                          */
/*           1                        */
/********************************************/ 	
/*
Uint8 NRF24L01_Check(void)
{
	Uint8 check_in_buf[5]={0x11,0x22,0x33,0x44,0x55};
	Uint8 check_out_buf[5]={0x00};	
	NRF_SCK=0;
	NRF_CSN=1;    
	NRF_CE=0;

	NRF24L01_Write_Buf(WRITE_REG+TX_ADDR, check_in_buf, 5);

	NRF24L01_Read_Buf(READ_REG+TX_ADDR, check_out_buf, 5);

	if((check_out_buf[0] == 0x11)&&\
	   (check_out_buf[1] == 0x22)&&\
	   (check_out_buf[2] == 0x33)&&\
	   (check_out_buf[3] == 0x44)&&\
	   (check_out_buf[4] == 0x55))return 0;
	else return 1;
}	*/

/**********************************************/
/* ܣ24L01ʼ                      */
/* ڲPLOAD_WIDTH  Чݿ        */
/* 			 TX_ADR  ͵ַ		          */
/* 		     TX_ADDR_WIDTH  ͵ַ      */
/* 			 RX_ADR  շ͵ַ        	  */
/* 			 RX_ADDR_WIDTH  յַ      */
/* 			 RATE  Чݿ        		  */
/* ֵ  	     	                      */
/**********************************************/
void    Initialisation_RF(void)
{   
        
		Nrf24l01_InterFace();  
		cbi(PC_DDR,4);		  
		NRF24L01_Write_Reg(WRITE_REG + RX_PW_P0, TX_PLOAD_WIDTH); //ýݳȣΪ32ֽ
		NRF24L01_Write_Reg(FLUSH_RX,0xff);//RX FIFOĴ    
		NRF24L01_Write_Buf(WRITE_REG + TX_ADDR, TX_ADDRESS,TX_ADR_WIDTH);//дTXڵַ 
		NRF24L01_Write_Buf(WRITE_REG + RX_ADDR_P0, RX_ADDRESS,RX_ADR_WIDTH); //RXڵַ,ҪΪʹACK
		
		NRF24L01_Write_Reg(WRITE_REG+EN_AA,0x01);     //ʹͨ0ԶӦ    
		NRF24L01_Write_Reg(WRITE_REG+EN_RXADDR,0x01); //ʹͨ0Ľյַ
		
		NRF24L01_Write_Reg(WRITE_REG+SETUP_RETR,0x1a);//Զطʱ:500us + 86us;Զط:10(a)
		NRF24L01_Write_Reg(WRITE_REG+RF_CH,0);        //RFͨΪ40 շһ£0Ϊ2.4GHz
		NRF24L01_Write_Reg(WRITE_REG+RF_SETUP,0x0f);  //TX,0db,1Mbps,濪   
		NRF24L01_Write_Reg(WRITE_REG+CONFIG,0x0f);    //ûģʽĲ;PWR_UP,EN_CRC,16BIT_CRC,ģʽ,ж
		sbi(PC_DDR,4);					//CEøߣʹܷ
}




